% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

% Skript zum Ausfhren der in Versuch 3 erstellten Funktionen
clear all
clc
stPendel = ladePendel();

% Hngendes Pendel AP = 0
% Stehendes Pendel AP = pi

AP = 0;

% Anfangswerte
x0 = [0.5 0 1*AP 0];


% Gewichtung Q, R

Q = diag([100 1 100 1]);

R = 1;


[A, B, C, D] = linPendelZR(stPendel, AP);

[K, poleRK] = berechneLQR(A, B, Q, R);

[vT, mX, vU] = runPendel(stPendel, AP, K, x0);

% Animation ohne Aufnahme eines Videos
animierePendel(vT, mX, stPendel, [], 0.025);
% % Animation mit Aufnahme eines Videos
% vFrames = animierePendel(vT, mX, stPendel, [], 0.025, 1);
% % Abspielen Video
% movie(figure(), vFrames, 1, 10)

% Plotten der Verufe u(t), x(t), phi(t)
plotResults(vT, mX, vU, Q, R);