% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

function [K, poleRK] = berechneLQR(A, B, Q, R)

	% Fehlerabfragen:  
	K = 'Error';
	poleRK = [];
    
	% Steuerbarkeit
	if ( rank(ctrb(A, B)) ~= length(A) )
		fprintf('Das System ist nicht steuerbar - LQR-Verfahren nicht anwendbar!');
		return;
	end

	% Test auf Symmetrie von Q:
	if ( any(any(Q ~= Q.')) )
		fprintf('Q muss symmetrisch gewhlt werden!');
		return;
	end

	% Test auf positive Definitheit:
	if ( any( eig(Q) <= 0 ) )
		fprintf('Q muss positiv definit gewhlt werden!');
		return;
	end

	if ( any( eig(R) <= 0 ) )
		fprintf('R muss positiv definit gewhlt werden!');
		return;
	end

	
	% Reglerberechnung:
    [K, ~, poleRK] = lqr(A, B, Q, R);
			% poleRK: Pole geschlossener Regelkreis
	
end % function berechneLQR
