% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

function sFunModell(block)

	setup(block);

end


% *************************************************************************
% Initialisierung
% *************************************************************************
function setup(block)

	% Anzahl der Ein-/Ausgnge
	block.NumInputPorts  = 1;
	block.NumOutputPorts = 1;

	% Eigenschaften des Eingangs
	block.InputPort(1).Dimensions	= 1;
	block.InputPort(1).DatatypeID	= 0;  % double
	block.InputPort(1).Complexity	= 'Real';
	block.InputPort(1).DirectFeedthrough = false;
	block.InputPort(1).SamplingMode = 'Sample';

	% Eigenschaften des 1. Ausgangs
	block.OutputPort(1).Dimensions	= 4;
	block.OutputPort(1).DatatypeID	= 0; % double
	block.OutputPort(1).Complexity	= 'Real';
	block.OutputPort(1).SamplingMode = 'Sample';

	
	% Anzahl der Zustnde
	block.NumContStates = 4;

	% Anzahl der Parameter
	block.NumDialogPrms = 7;


	% Abtastzeit definieren -> zeitkontinuierlich
	block.SampleTimes = [0 0];


	
	% weitere Methoden registrieren
	block.RegBlockMethod('InitializeConditions', @InitializeConditions);
	block.RegBlockMethod('Outputs', @Outputs);
	block.RegBlockMethod('Derivatives', @Derivatives);
	block.RegBlockMethod('Terminate', @Terminate);

end


% *************************************************************************
% Anfangsbedingungen setzen
% *************************************************************************
function InitializeConditions(block)

	phi0 = block.DialogPrm(7).Data;
	block.ContStates.Data = [0.5; 0; phi0; 0];
	
end


% *************************************************************************
% Ausgnge berechnen
% *************************************************************************
function Outputs(block)

	% Zustnde auslesen
	x		= block.ContStates.Data;
	xs		= x(1);
	phi		= x(3);

	block.OutputPort(1).Data = block.ContStates.Data;

end


% *************************************************************************
% Ableitungen berechnen
% *************************************************************************
function Derivatives(block)

	% Parameter auslesen
	ms = block.DialogPrm(1).Data;
	Rs = block.DialogPrm(2).Data;
	mp = block.DialogPrm(3).Data;
	Rp = block.DialogPrm(4).Data;
	l = block.DialogPrm(5).Data;
	g = block.DialogPrm(6).Data;

	% Zustnde auslesen
	x		= block.ContStates.Data;
	xs		= x(1);
	xs_d	= x(2);
	phi		= x(3);
	phi_d	= x(4);

	% Eingang auslesen
	F = block.InputPort(1).Data(1);

	
	
	% Ableitungen berechnen
	xs_dd = (-4*l*Rs*xs_d+2*mp*phi_d^2*l^2*sin(phi)+4*l*F+3*cos(phi)*l*mp*g*sin(phi)+6*cos(phi)*Rp*phi_d)/l/(4*ms+4*mp-3*mp*cos(phi)^2);
	phi_dd = -3*(-2*Rs*xs_d*l*mp*cos(phi)+mp^2*phi_d^2*l^2*sin(phi)*cos(phi)+2*F*l*mp*cos(phi)+2*ms*l*mp*g*sin(phi)+2*l*mp^2*g*sin(phi)+4*ms*Rp*phi_d+4*mp*Rp*phi_d)/l^2/mp/(4*ms+4*mp-3*mp*cos(phi)^2);
	
	

	% Ableitungen zuweisen
	block.Derivatives.Data = [xs_d; xs_dd; phi_d; phi_dd ];
	
end


% *************************************************************************
% Aufrumen (wenn ntig)
% *************************************************************************
function Terminate(block)
end
