% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

function dxdt = SchlittenpendelGesteuertDGL(t, x, stPendel, stTraj)     % t zeit, x Zustnde

	persistent m s g J p1 p2 T

	if (nargin > 3)

		M = stPendel.mSchlitten;
		m = stPendel.mPendel;
		l = stPendel.lPendel;
		s = l/2;
		g = stPendel.g;
		J = 1/12 * stPendel.mPendel * stPendel.lPendel^2;

		T = stTraj.T;
		p1 = stTraj.P(1);
		p2 = stTraj.P(2);
		dxdt = 0;
		return

	end

	u = ( 6*(-p1 - 3*p2)*(t/T) + 12*(3*p1 + 8*p2)*(t/T)^2 + 20*(-3*p1 - 6*p2)*(t/T)^3 +...
		30*p1*(t/T)^4 + 42*p2*(t/T)^5 ) / (T^2);

	% u nur Zeitintervall der Eingangssteuerfolge bercksichtigen,
	% danach u = 0
	if (t <= T )        
		dxdt = [
		   x(2);
			u ;
			x(4) ;
			-m*s*g/(m*s^2+J)*sin(x(3)) - m*s/(m*s^2+J)*cos(x(3))*u;  % f(4) + g(4) * u
			];
	else
		dxdt = [
			x(2);
			0 ;
			x(4) ;
			-m*s*g/(m*s^2+J)*sin(x(3)) ;  % f(4) 
			];
	end
       
end % function SchlittenpendelGesteuertDGL