% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

% Berechnung der Differentialgleichung fr die berechneten Parameter

T = stTraj.T;

% Initialisierung der Differentialgleichung 
SchlittenpendelGesteuertDGL(0, 0, ladePendel(), stTraj);


[t2 , f] = ode45(@SchlittenpendelGesteuertDGL, [0 T+1], [0, 0, 0, 0]);
% Lsen der Differentialgleichung fr Zeit T+x und Anfangswerte, verschiedene Solver, verschiedene
% Ergebnisse, wie was auch die Darstellung mit simPendel deutlich zeigt
% mit ode45 fllt das Pendel nach links, mit ode23 nach rechts wieder runter

subplot(4,1,1)
plot(t2, f(:,1))
title('Trajektorie: Weg des Schlittens')
axis tight

subplot(4,1,2)
plot(t2, f(:,2))
title('Trajektorie: Geschwindigkeit des Schlittens')
axis tight

subplot(4,1,3)
plot(t2, f(:,3))
title('Trajektorie: Winkel des Pendels')
axis tight

subplot(4,1,4)
plot(t2, f(:,4))
title('Trajektorie: Winkelgeschwindigkeit des Pendels')
axis tight
% Plotten aller Zustnde 

animierePendel(t2, f, ladePendel(), [], 0.025, 0);
% Aufruf der graphischen Simulation

   
% Aufrumen des Workspace
clear T t2 f;