% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

clear all
clc;

% Trajektorie laden
l = load( 'Trajektorien' );
stTraj = l.caTraj{2};


% Pendel laden
stPendel = ladePendel();
% Gesamtmasse unbedingt vor dem Verflschen der
% Pendeldaten berechnen.
Mges =  stPendel.mPendel + stPendel.mSchlitten;

% Pendeldaten verflschen
stPendel.lPendel = 1.05 * stPendel.lPendel;
stPendel.mPendel = 1 * stPendel.mPendel;

% Trajektorienfolgeregelung benutzen? 0 or 1
iFeedbackOn = 1;

% Modell mit Krafteingang benutzen? 0 or 1
iForceInput = 0;
% Motorkonstante
T_Motor = 0.01;


% Trajektorie laden
%load Traj.mat

Q = diag([1 1 1 1]);
R = 1;

[vTK, mK] = berechneK(stPendel, stTraj, Q, R);

% Aufschwung startet unten
x0 = [0 0 0 0].';

sim('RegelungV6.slx', stTraj.T+6);

animierePendel(vT, mStates, stPendel, [], 0.01, 0);
