% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

function systemPendel_V3(block)

	setup(block);

end


% ********************************************************************
% Initialisierung
% ********************************************************************
function setup(block)

	% Anzahl der Ein-/Ausgnge
	block.NumInputPorts  = 1;
	block.NumOutputPorts = 1;

	% Eigenschaften des Eingangs
	block.InputPort(1).Dimensions	= 1;
	block.InputPort(1).DatatypeID	= 0;  % double
	block.InputPort(1).Complexity	= 'Real';
	block.InputPort(1).DirectFeedthrough = false;
	block.InputPort(1).SamplingMode = 'Sample';

	% Eigenschaften des 1. Ausgangs
	block.OutputPort(1).Dimensions	= 4;
	block.OutputPort(1).DatatypeID	= 0; % double
	block.OutputPort(1).Complexity	= 'Real';
	block.OutputPort(1).SamplingMode = 'Sample';
	
	% Anzahl der Zustnde
	block.NumContStates = 4;

	% Anzahl der Parameter
	block.NumDialogPrms = 2;


	% Abtastzeit definieren -> zeitkontinuierlich
	block.SampleTimes = [0 0];


	
	% weitere Methoden registrieren
	block.RegBlockMethod('InitializeConditions', @InitializeConditions);
	block.RegBlockMethod('Outputs', @Outputs);
	block.RegBlockMethod('Derivatives', @Derivatives);
	block.RegBlockMethod('Terminate', @Terminate);

end


% ********************************************************************
% Anfangsbedingungen setzen
% ********************************************************************
function InitializeConditions(block)

	x0 = block.DialogPrm(2).Data;
	block.ContStates.Data = x0;
	
end


% ********************************************************************
% Ausgnge berechnen
% ********************************************************************
function Outputs(block)

	% Zustnde ausgeben
	block.OutputPort(1).Data = block.ContStates.Data;

end


% ********************************************************************
% Ableitungen berechnen
% ********************************************************************
function Derivatives(block)

	% Parameter auslesen
	stPendel = block.DialogPrm(1).Data;
	ms = stPendel.mSchlitten;
	mp = stPendel.mPendel;
	l  = stPendel.lPendel;
	g  = stPendel.g;

	% Zustnde auslesen
	x		= block.ContStates.Data;
	xs		= x(1);
	xs_d	= x(2);
	phi		= x(3);
	phi_d	= x(4);

	% Eingang auslesen
	F = block.InputPort(1).Data(1);

	
	% Ableitungen berechnen
	phi_dd = ( ...
                (ms + mp) * (g * sin(phi)) + ...
                    mp * phi_d^2 * l/4 * sin(2*phi) + ...
                    cos(phi) * (F) ...
              ) / (mp * l/2 * cos(phi)^2 - (ms + mp) * 2/3 * l);
            
	xs_dd = -1/cos(phi) * ...
               (g * sin(phi) + 2/3 * l * phi_dd);
           
	x_d = [	xs_d;
            xs_dd;
            phi_d;
            phi_dd];

	% Ableitungen zuweisen
	block.Derivatives.Data = x_d;
	
end


% ********************************************************************
% Aufrumen (wenn ntig)
% ********************************************************************
function Terminate(block)
end
